package com.example.sefinsa_app.utilities;

import java.util.List;

import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;

public interface RetrofitInterface {
    /*@Multipart
    @POST("Archivo/App.php")
    Call<ResponseMe> uploadImage(@Part MultipartBody.Part image, @Part MultipartBody.Part nombre);*/


    @Multipart
    @POST("Clientes/App.php")
    Call<ResponseMe> registrarCliente(@Part List<MultipartBody.Part> image,
                                      @Part("func") RequestBody func,
                                      @Part("cliente_id") RequestBody cliente_id,
                                      @Part("direccion_cliente") RequestBody direccion_cliente,
                                      @Part("telefono_cliente") RequestBody telefono_cliente,
                                      @Part("or_cliente") RequestBody or_cliente,
                                      @Part("garantias_cliente") RequestBody garantias_cliente,
                                      @Part("ruta_id") RequestBody ruta_id,
                                      @Part("poblacion_id") RequestBody poblacion_id,
                                      @Part("colocadora_id") RequestBody colocadora_id,
                                      @Part("cantidad_archivos_garantias_cliente") RequestBody cantidad_archivos_garantias_cliente,
                                      @Part("cantidad_archivos_cliente") RequestBody cantidad_archivos_cliente,

                                      @Part("nombre_aval") RequestBody nombre_aval,
                                      @Part("direccion_aval") RequestBody direccion_aval,
                                      @Part("telefono_aval") RequestBody telefono_aval,
                                      @Part("or_aval") RequestBody or_aval,
                                      @Part("garantias_aval") RequestBody garantias_aval,
                                      @Part("cantidad_archivos_garantias_aval") RequestBody cantidad_archivos_garantias_aval,
                                      @Part("cantidad_archivos_aval") RequestBody cantidad_archivos_aval,
                                      @Part("latitud") RequestBody latitud,
                                      @Part("longitud") RequestBody longitud,
                                      @Part("colocadora_idAval") RequestBody colocadora_idAval,
                                      @Part("ruta_idAval") RequestBody ruta_idAval,
                                      @Part("poblacion_idAval") RequestBody poblacion_idAval,

                                      @Part("latitudAval") RequestBody latitudAval,
                                      @Part("longitudAval") RequestBody longitudAval
    );

    @Multipart
    @POST("Clientes/App.php")
    Call<ResponseMe> registrarClienteSolo(@Part List<MultipartBody.Part> image,
                                      @Part("func") RequestBody func,
                                      @Part("nombre_cliente") RequestBody nombre_cliente,
                                      @Part("direccion_cliente") RequestBody direccion_cliente,
                                      @Part("telefono_cliente") RequestBody telefono_cliente,
                                      @Part("or_cliente") RequestBody or_cliente,
                                      @Part("garantias_cliente") RequestBody garantias_cliente,
                                      @Part("ruta_id") RequestBody ruta_id,
                                      @Part("poblacion_id") RequestBody poblacion_id,
                                      @Part("colocadora_id") RequestBody colocadora_id,
                                      @Part("cantidad_archivos_garantias_cliente") RequestBody cantidad_archivos_garantias_cliente,
                                      @Part("cantidad_archivos_cliente") RequestBody cantidad_archivos_cliente,
                                      @Part("latitud") RequestBody latitud,
                                      @Part("longitud") RequestBody longitud,
                                          @Part("aval_id") RequestBody aval_final
    );

    @Multipart
    @POST("Clientes/App.php")
    Call<ResponseMe> registrarAvalACliente(@Part List<MultipartBody.Part> image,
                                          @Part("func") RequestBody func,
                                          @Part("nombre_completo") RequestBody nombre_completo,
                                          @Part("direccion") RequestBody direccion_cliente,
                                          @Part("telefono") RequestBody telefono_cliente,
                                          @Part("otras_referencias") RequestBody or_cliente,
                                          @Part("garantias") RequestBody garantias_cliente,
                                          @Part("ruta_id") RequestBody ruta_id,
                                          @Part("poblacion_id") RequestBody poblacion_id,
                                          @Part("colocadora_id") RequestBody colocadora_id
    );

    @Multipart
    @POST("Avales/App.php")
    Call<ResponseMe> registrarAval(@Part List<MultipartBody.Part> image,
                                      @Part("func") RequestBody func,
                                      @Part("nombre_aval") RequestBody nombre_aval,
                                      @Part("direccion") RequestBody direccion_aval,
                                      @Part("telefono") RequestBody telefono_aval,
                                      @Part("rutaId") RequestBody rutaId,
                                      @Part("poblacionId") RequestBody poblacionId,
                                      @Part("colocadoraId") RequestBody colocadoraId,
                                      @Part("or_aval") RequestBody or_aval,
                                      @Part("garantias_aval") RequestBody garantias_aval,
                                      @Part("cantidad_archivos_garantias_aval") RequestBody cantidad_archivos_garantias_aval,
                                      @Part("cantidad_archivos_aval") RequestBody cantidad_archivos_aval,
                                      @Part("latitud") RequestBody latitud,
                                      @Part("longitud") RequestBody longitud

    );

    @Multipart
    @POST("Clientes/App.php")
    Call<ResponseMe> editarClienteSolo(@Part List<MultipartBody.Part> image,
                                   @Part("func") RequestBody func,
                                   @Part("id") RequestBody cliente_id,
                                   @Part("nombre_completo") RequestBody nombre_cliente,
                                   @Part("direccion") RequestBody direccion_cliente,
                                   @Part("telefono") RequestBody telefono_cliente,
                                   @Part("otras_referencias") RequestBody or_cliente,
                                   @Part("garantias") RequestBody garantias_cliente,
                                   @Part("ruta_id") RequestBody ruta_id,
                                   @Part("poblacion_id") RequestBody poblacion_id,
                                   @Part("colocadora_id") RequestBody colocadora_id,
                                   @Part("cantidad_archivos_cliente") RequestBody cantidad_archivos_cliente,
                                       @Part("cantidad_archivos_garantias_cliente") RequestBody cantidad_archivos_garantias_cliente,
                                       @Part("latitud") RequestBody latitud,
                                   @Part("longitud") RequestBody longitud
    );

    @Multipart
    @POST("Clientes/App.php")
    Call<ResponseMe> editarCliente(@Part List<MultipartBody.Part> image,
                                   @Part("func") RequestBody func,
                                   @Part("id") RequestBody cliente_id,
                                   @Part("nombre_completo") RequestBody nombre_cliente,
                                   @Part("direccion") RequestBody direccion_cliente,
                                   @Part("telefono") RequestBody telefono_cliente,
                                   @Part("otras_referencias") RequestBody or_cliente,
                                   @Part("garantias") RequestBody garantias_cliente,
                                   @Part("ruta_id") RequestBody ruta_id,
                                   @Part("poblacion_id") RequestBody poblacion_id,
                                   @Part("colocadora_id") RequestBody colocadora_id,
                                   @Part("aval_id") RequestBody avalId,
                                   @Part("nombre_completo_aval") RequestBody nombre_aval,
                                   @Part("direccion_aval") RequestBody direccion_aval,
                                   @Part("telefono_aval") RequestBody telefono_aval,
                                   @Part("otras_referencias_aval") RequestBody or_aval,
                                   @Part("garantias_aval") RequestBody garantias_aval,
                                   @Part("latitud") RequestBody latitud,
                                   @Part("longitud") RequestBody longitud,
                                   @Part("ruta_idAval") RequestBody ruta_aval,
                                   @Part("poblacion_idAval") RequestBody poblacion_aval,
                                   @Part("colocadora_idAval") RequestBody colocadora_aval,
                                   @Part("latitudAval") RequestBody latitudAval,
                                   @Part("longitudAval") RequestBody longitudAval
    );

    @Multipart
    @POST("Avales/App.php")
    Call<ResponseMe> editarAval(@Part List<MultipartBody.Part> image,
                                   @Part("func") RequestBody func,
                                   @Part("id") RequestBody avalId,
                                   @Part("nombre_completo_aval") RequestBody nombre_aval,
                                   @Part("direccion_aval") RequestBody direccion_aval,
                                   @Part("telefono_aval") RequestBody telefono_aval,
                                   @Part("ruta_id") RequestBody ruta_id,
                                   @Part("poblacion_id") RequestBody poblacion_id,
                                   @Part("colocadora_id") RequestBody colocadora_id,
                                   @Part("otras_referencias_aval") RequestBody or_aval,
                                   @Part("garantias_aval") RequestBody garantias_aval,
                                   @Part("cantidad_archivos_garantias_aval") RequestBody cantidad_archivos_garantias_aval,
                                   @Part("cantidad_archivos_aval") RequestBody cantidad_archivos_aval,
                                @Part("latitud") RequestBody latitud,
                                @Part("longitud") RequestBody longitud
    );

    @Multipart
    @POST("Clientes/App.php")
    Call<ResponseMe> subirFotos(@Part List<MultipartBody.Part> image,
                                @Part("func") RequestBody func,
                                @Part("cliente_id") RequestBody cliente_id,
                                @Part("cantidad_archivos_garantias_cliente") RequestBody cantidad_archivos_garantias_cliente,
                                @Part("cantidad_archivos_cliente") RequestBody cantidad_archivos_cliente,
                                @Part("cantidad_archivos_garantias_aval") RequestBody cantidad_archivos_garantias_aval,
                                @Part("cantidad_archivos_aval") RequestBody cantidad_archivos_aval,
                                @Part("latitud") RequestBody latitud,
                                @Part("longitud") RequestBody longitud,
                                @Part("aval_id") RequestBody aval_id
    );
    @Multipart
    @POST("Clientes/App.php")
    Call<ResponseMe> subirFotosPC(@Part List<MultipartBody.Part> image,
                                 @Part("func") RequestBody func,
                                 @Part("cliente_id") RequestBody cliente_id,
                                 @Part("cantidad_archivos_garantias_cliente") RequestBody cantidad_archivos_garantias_cliente,
                                 @Part("cantidad_archivos_cliente") RequestBody cantidad_archivos_cliente,
                                 @Part("latitud") RequestBody latitud,
                                 @Part("longitud") RequestBody longitud
    );

    @Multipart
    @POST("Clientes/App.php")
    Call<ResponseMe> subirFotosP(@Part List<MultipartBody.Part> image,
                                @Part("func") RequestBody func,
                                @Part("cliente_id") RequestBody cliente_id,
                                @Part("cantidad_archivos_garantias_cliente") RequestBody cantidad_archivos_garantias_cliente,
                                @Part("cantidad_archivos_cliente") RequestBody cantidad_archivos_cliente,
                                @Part("cantidad_archivos_garantias_aval") RequestBody cantidad_archivos_garantias_aval,
                                @Part("cantidad_archivos_aval") RequestBody cantidad_archivos_aval,
                                @Part("latitud") RequestBody latitud,
                                @Part("longitud") RequestBody longitud,
                                 @Part("aval_id") RequestBody aval_id
    );

    @Multipart
    @POST("Avales/App.php")
    Call<ResponseMe> subirFotosA(@Part List<MultipartBody.Part> image,
                                 @Part("func") RequestBody func,
                                 @Part("aval_id") RequestBody aval_id,
                                 @Part("cantidad_archivos_garantias_aval") RequestBody cantidad_archivos_garantias_aval,
                                 @Part("cantidad_archivos_aval") RequestBody cantidad_archivos_aval
    );

    @Multipart
    @POST("Clientes/App.php")
    Call<ResponseMe> subirFotosCA(@Part List<MultipartBody.Part> image,
                                 @Part("func") RequestBody func,
                                 @Part("cliente_id") RequestBody cliente_id,
                                 @Part("cantidad_archivos_garantias_cliente") RequestBody cantidad_archivos_garantias_cliente,
                                 @Part("cantidad_archivos_cliente") RequestBody cantidad_archivos_cliente
    );

    @Multipart
    @POST("Clientes/App.php")
    Call<ResponseMe> subirFotosCYA(@Part List<MultipartBody.Part> image,
                                  @Part("func") RequestBody func,
                                  @Part("cliente_id") RequestBody cliente_id,
                                  @Part("cantidad_archivos_garantias_cliente") RequestBody cantidad_archivos_garantias_cliente,
                                  @Part("cantidad_archivos_cliente") RequestBody cantidad_archivos_cliente,
                                   @Part("aval_id") RequestBody aval_id,
                                   @Part("cantidad_archivos_garantias_aval") RequestBody cantidad_archivos_garantias_aval,
                                   @Part("cantidad_archivos_aval") RequestBody cantidad_archivos_aval
    );

    @Multipart
    @POST("Clientes/App.php")
    Call<ResponseMe> subirFotosGarantiasRetiradas(@Part List<MultipartBody.Part> image,
                                                  @Part("func") RequestBody func,
                                                  @Part("cliente_id") RequestBody cliente_id,
                                                  @Part("garantias_retiradas_cliente") RequestBody garantias_retiradas_cliente,
                                                  @Part("fecha_pago") RequestBody fecha_pago,
                                                  @Part("empleado_id") RequestBody empleado_id,
                                                  @Part("descripcion") RequestBody descripcion
    );
    @Multipart
    @POST("Pagos/App.php")
    Call<ResponseMe> actualizarSemanaGarantia(@Part List<MultipartBody.Part> image,
                                                  @Part("func") RequestBody func,
                                                  @Part("prestamo_id") RequestBody prestamo_id,
                                                  @Part("semana") RequestBody semana
    );
}